from machine import Pin, PWM
import machine

freqs = range(50000000, 250000000, 1000000)
fbest = 120000000
fbest2 =  12400000
for f in freqs:
    machine.freq(f)

    # create PWM object from a pin and set the frequency of slice 0
    # and duty cycle for channel A
    pwm0 = PWM(Pin(0), freq=256*48000, duty_u16=32768)
    print(pwm0.freq())
    f1 = 12288000   # 256*48000  desired frequency
    pwm0.freq(f1)
    f2 = pwm0.freq()  # achieved frequency
    pwm0.deinit()           # turn off PWM of slice 0, stopping channels A and B
    print('f2', f2, 'f2/f1', f2/f1, 'Machine frequency', machine.freq())
    if abs(f2/f1 -1) < abs(fbest2/f1 -1):
        fbest = f
        fbest2 = f2
print('fbest', fbest, 'fbest2', fbest2, 'fbest2/12288000', fbest2/12288000)